#version 330 core
uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;

void main()
{
	vec3 offset = vec3(0.0);
	if ( TEXCOORD.y > 0.99 )
	{
		offset.x = sin(time + POSITION.z*1.57)*0.1;
		offset.z = cos(time + POSITION.x*1.57)*0.1;
	}

	uv = TEXCOORD;

	normal = NormalMatrix * NORMAL; //vec3(gl_ModelViewMatrix * vec4(NORMAL, 0.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION + offset, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
